/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.drop;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.entity.data.EnchantSet;

public class SubGuiDropEnchant
extends SubGuiInterface
implements ITextfieldListener {
    public EnchantSet enchant;
    public String[] enchIds;
    public int[] levels;

    public SubGuiDropEnchant(EnchantSet ench) {
        this.setBackground("companion_empty.png");
        this.xSize = 172;
        this.ySize = 167;
        this.closeOnEsc = true;
        this.enchant = ench;
        ArrayList<Integer> el = new ArrayList<Integer>();
        for (Enchantment en : ForgeRegistries.ENCHANTMENTS.getValuesCollection()) {
            el.add(Enchantment.func_185258_b((Enchantment)en));
        }
        Collections.sort(el);
        this.enchIds = new String[el.size()];
        for (int i = 0; i < el.size(); ++i) {
            this.enchIds[i] = "" + el.get(i);
        }
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (button.getID() == 50) {
            this.enchant.setEnchant(Integer.parseInt(button.getVariants()[button.getValue()]));
            this.func_73866_w_();
        } else if (button.getID() == 51) {
            this.close();
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int anyIDs = 60;
        String name = new TextComponentTranslation("drop.enchants", new Object[0]).func_150254_d() + ": " + new TextComponentTranslation(this.enchant.getEnchant(), new Object[0]).func_150254_d();
        this.addLabel(new GuiNpcLabel(anyIDs++, name, this.guiLeft + 4, this.guiTop + 5));
        int posId = 0;
        String idName = "" + Enchantment.func_185258_b((Enchantment)this.enchant.ench);
        for (int i = 0; i < this.enchIds.length; ++i) {
            if (!this.enchIds[i].equals(idName)) continue;
            posId = i;
        }
        GuiNpcButton button = new GuiButtonBiDirectional(50, this.guiLeft + 4, this.guiTop + 17, 80, 20, this.enchIds, posId);
        button.setHoverText("drop.hover.enchant.list", new Object[0]);
        this.addButton(button);
        this.levels = new int[]{this.enchant.getMinLevel(), this.enchant.getMaxLevel()};
        this.addLabel(new GuiNpcLabel(anyIDs++, "type.level", this.guiLeft + 56, this.guiTop + 48));
        String tied = new TextComponentTranslation("drop.tied.random", new Object[0]).func_150254_d();
        if (this.enchant.parent.tiedToLevel) {
            tied = new TextComponentTranslation("drop.tied.level", new Object[0]).func_150254_d();
        }
        GuiNpcTextField textField = new GuiNpcTextField(52, this, this.guiLeft + 4, this.guiTop + 39, 50, 14, "" + this.levels[0]);
        textField.setMinMaxDefault(0L, 100000L, this.enchant.getMinLevel());
        textField.setHoverText("drop.hover.enchant.levels", "" + this.enchant.ench.func_77325_b(), tied);
        this.addTextField(textField);
        textField = new GuiNpcTextField(53, this, this.guiLeft + 4, this.guiTop + 53, 50, 14, "" + this.levels[1]);
        textField.setMinMaxDefault(0L, 100000L, this.enchant.getMaxLevel());
        textField.setHoverText("drop.hover.enchant.levels", "" + this.enchant.ench.func_77325_b(), tied);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(anyIDs, "drop.chance", this.guiLeft + 56, this.guiTop + 74));
        textField = new GuiNpcTextField(54, this, this.guiLeft + 4, this.guiTop + 69, 50, 20, String.valueOf(this.enchant.getChance()));
        textField.setMinMaxDoubleDefault(1.0E-4, 100.0, this.enchant.getChance());
        textField.setHoverText("drop.hover.enchant.chance", new Object[0]);
        this.addTextField(textField);
        button = new GuiNpcButton(51, this.guiLeft + 4, this.guiTop + 142, 80, 20, "gui.done");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void unFocused(IGuiNpcTextField textfield) {
        if (textfield.getID() == 52) {
            this.levels[0] = textfield.getInteger();
            this.enchant.setLevels(this.levels[0], this.levels[1]);
            this.func_73866_w_();
        } else if (textfield.getID() == 53) {
            this.levels[1] = textfield.getInteger();
            this.enchant.setLevels(this.levels[0], this.levels[1]);
            this.func_73866_w_();
        } else if (textfield.getID() == 54) {
            this.enchant.setChance(textfield.getDouble());
            this.func_73866_w_();
        }
    }
}

